% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make-array.R
\name{flipArrays}
\alias{flipArrays}
\title{Rearrange array subvariables}
\usage{
flipArrays(variables, suffix = ", flipped")
}
\arguments{
\item{variables}{List of variables, a variable catalog, or a dataset subset
containing the categorical array or multiple response variables you want to
rearrange.}

\item{suffix}{character string to append to the new variable names. Pass
\code{""} if you don't want it to append anything.}
}
\value{
A list of derived VariableDefinitions, one per unique subvariable
name across all \code{variables}. Each variable in \code{variables} that
contains this subvariable will appear as a subvariable in these new derived
array definitions. Use \code{\link{addVariables}} to add these to your dataset.
}
\description{
Sometimes it is useful to group subvariables across arrays in order to
compare them more easily. This function generates a set of derived views of
common subvariables across arrays. Because they are derived, they share data
with the underlying array variables, and they are thus automatically updated
when new data is appended.
}
\examples{
\dontrun{
ds <- addVariables(ds, flipArrays(ds[c("petloc", "petloc2")], suffix=", rearranged"))
}
}
