% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new-dataset.R
\name{createWithPreparedData}
\alias{createWithPreparedData}
\title{Upload a prepared data.frame with metadata to Crunch}
\usage{
createWithPreparedData(data, metadata = attr(data, "metadata"))
}
\arguments{
\item{data}{a data.frame that meets the Crunch API specification, as returned
by \code{\link{prepareDataForCrunch}}, or a character path to a file or URL
where such data has been written as CSV.}

\item{metadata}{list of Crunch metadata that corresponds to \code{data}.
Default is the "metadata" attribute of \code{data}, as returned by
\code{prepareDataForCrunch}, or a character path to a file where such
metadata has been written as JSON.}
}
\value{
A CrunchDataset.
}
\description{
Upload a prepared data.frame with metadata to Crunch
}
