% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expressions.R
\docType{methods}
\name{expressions}
\alias{expressions}
\alias{!,CrunchExpr-method}
\alias{\%in\%,CategoricalVariable,character-method}
\alias{\%in\%,CategoricalVariable,factor-method}
\alias{\%in\%,TextVariable,character-method}
\alias{\%in\%,NumericVariable,numeric-method}
\alias{\%in\%,DatetimeVariable,Date-method}
\alias{\%in\%,DatetimeVariable,POSIXt-method}
\alias{\%in\%,DatetimeVariable,character-method}
\alias{\%in\%,CategoricalVariable,numeric-method}
\alias{==,CategoricalVariable,character-method}
\alias{==,CategoricalVariable,factor-method}
\alias{!=,CategoricalVariable,character-method}
\alias{!=,CategoricalVariable,factor-method}
\alias{is.na,CrunchVariable-method}
\alias{bin}
\alias{rollup}
\title{Construct Crunch Expressions}
\usage{
\S4method{!}{CrunchExpr}(x)

\S4method{\%in\%}{CategoricalVariable,character}(x, table)

\S4method{\%in\%}{CategoricalVariable,factor}(x, table)

\S4method{\%in\%}{TextVariable,character}(x, table)

\S4method{\%in\%}{NumericVariable,numeric}(x, table)

\S4method{\%in\%}{DatetimeVariable,Date}(x, table)

\S4method{\%in\%}{DatetimeVariable,POSIXt}(x, table)

\S4method{\%in\%}{DatetimeVariable,character}(x, table)

\S4method{\%in\%}{CategoricalVariable,numeric}(x, table)

\S4method{==}{CategoricalVariable,character}(e1, e2)

\S4method{==}{CategoricalVariable,factor}(e1, e2)

\S4method{!=}{CategoricalVariable,character}(e1, e2)

\S4method{!=}{CategoricalVariable,factor}(e1, e2)

\S4method{is.na}{CrunchVariable}(x)

bin(x)

rollup(x, resolution = rollupResolution(x))
}
\arguments{
\item{x}{an input}

\item{table}{For \code{\%in\%}. See \code{\link[base]{match}}}

\item{e1}{an input}

\item{e2}{an input}

\item{resolution}{For \code{rollup}. Either \code{NULL} or a character in
c("Y", "Q", "M", "W", "D", "h", "m", "s", "ms") indicating the unit of
time at which a Datetime variable should be aggregated. If \code{NULL},
the server will determine an appropriate resolution based on the range of
the data.}
}
\value{
Most functions return a CrunchExpr or CrunchLogicalExpr.
\code{as.vector} returns an R vector.
}
\description{
Crunch Expressions, i.e. \code{CrunchExpr} and \code{CrunchLogicalExpr},
encapuslate derivations of Crunch variables, which are only evaluated when
passed to a function like \code{as.vector}. They allow you to compose
functional expressions of variables and evaluate them against the server
only when appropriate.
}
