% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/suggest_crs.R
\name{suggest_crs}
\alias{suggest_crs}
\title{Suggest coordinate systems for an input spatial dataset}
\usage{
suggest_crs(input, type = "projected", limit = 10, gcs = NULL, units = NULL)
}
\arguments{
\item{input}{A spatial dataset of class \code{"sf"}, \code{"Spatial*"}, or
\code{"RasterLayer"}.}

\item{type}{The output CRS type; defaults to \code{"projected"}.}

\item{limit}{How many results to return; defaults to \code{10}.}

\item{gcs}{(optional) The EPSG code for the corresponding geographic coordinate system of the results (e.g. \code{4326} for WGS 1984).}

\item{units}{(optional) The measurement units of the coordinate systems in the returned results.  Can be one of \code{"m"}, \code{"ft"}, or \code{"ft-us"}.}
}
\value{
A data frame with information about coordinate reference systems that could be suitably used for CRS transformation.
}
\description{
This function takes an input spatial dataset as input and makes "suggestions" for suitable
coordinate reference systems that could be used for CRS transformations in spatial analysis
projects.  The function works by analyzing the extent of the spatial dataset and comparing it
to the area extents in the EPSG's coordinate reference system database.  The "suggested"
coordinate reference systems are determined by minimizing the Haussdorf distances between
the CRS area extents and the input dataset, subject to user preferences (such as
a geographic coordinate system ID or measurement units).
}
\examples{
\dontrun{

library(tigris)
library(crsuggest)

# Get a dataset of Census tracts for Nassau County, NY
nassau_tracts <- tracts("NY", "Nassau", cb = TRUE)

# tigris datasets default to the NAD1983 GCS (EPSG code 4269)
# What are some appropriate projected coordinate systems?
suggest_crs(nassau_tracts)

# Alternatively, we can require projections to have specific
# geographic coordinate systems and/or units
# For example, let's say we only want NAD83(HARN) (code 4152)
# and we want the measurement units to be US feet
suggest_crs(nassau_tracts, gcs = 4152, units = "us-ft")

}
}
