% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crsra_import.R
\name{crsra_import}
\alias{crsra_import}
\title{Imports all the .csv files into one list consisting of all
the courses and all the tables within each course.}
\usage{
crsra_import(workdir = ".", ...)
}
\arguments{
\item{workdir}{A character string vector indicating the directory
where all the unzipped course directories are stored.}

\item{...}{Additional arguments to pass to
\code{\link{crsra_import_course}}}
}
\description{
Imports all the .csv files into one list consisting of all
the courses and all the tables within each course.
}
\examples{
zip_file = system.file("extdata", "fake_course_7051862327916.zip",
package = "crsra")
bn = basename(zip_file)
bn = sub("[.]zip$", "", bn)
res = unzip(zip_file, exdir = tempdir(), overwrite = TRUE)
example_import = crsra_import(workdir = tempdir(),
check_problems = FALSE)

}
