% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/future_map_vec.R
\name{future_map_vec}
\alias{future_map_vec}
\alias{future_map2_vec}
\alias{future_pmap_vec}
\alias{future_imap_vec}
\alias{future_xmap_vec}
\title{Parallelized mapping functions that automatically determine type}
\usage{
future_map_vec(
  .x,
  .f,
  ...,
  .class = NULL,
  .progress = FALSE,
  .options = furrr::furrr_options()
)

future_map2_vec(
  .x,
  .y,
  .f,
  ...,
  .class = NULL,
  .progress = FALSE,
  .options = furrr::furrr_options()
)

future_pmap_vec(
  .l,
  .f,
  ...,
  .class = NULL,
  .progress = FALSE,
  .options = furrr::furrr_options()
)

future_imap_vec(
  .x,
  .f,
  ...,
  .class = NULL,
  .progress = FALSE,
  .options = furrr::furrr_options()
)

future_xmap_vec(
  .l,
  .f,
  ...,
  .class = NULL,
  .progress = FALSE,
  .options = furrr::furrr_options()
)
}
\arguments{
\item{.x}{A list or atomic vector.}

\item{.f}{A function, formula, or vector (not necessarily atomic).

If a \strong{function}, it is used as is.

If a \strong{formula}, e.g. \code{~ .x + 2}, it is converted to a function. There
are three ways to refer to the arguments:
\itemize{
\item For a single argument function, use \code{.}
\item For a two argument function, use \code{.x} and \code{.y}
\item For more arguments, use \code{..1}, \code{..2}, \code{..3} etc
}

This syntax allows you to create very compact anonymous functions.

If \strong{character vector}, \strong{numeric vector}, or \strong{list}, it is
converted to an extractor function. Character vectors index by
name and numeric vectors index by position; use a list to index
by position and name at different levels. If a component is not
present, the value of \code{.default} will be returned.}

\item{...}{Additional arguments passed on to \code{.f}}

\item{.class}{If \code{.class} is specified, all}

\item{.progress}{A single logical. Should a progress bar be displayed?
Only works with multisession, multicore, and multiprocess futures. Note
that if a multicore/multisession future falls back to sequential, then
a progress bar will not be displayed.

\strong{Warning:} The \code{.progress} argument will be deprecated and removed
in a future version of furrr in favor of using the more robust
\href{https://CRAN.R-project.org/package=progressr}{progressr}
package.}

\item{.options}{The \code{future} specific options to use with the workers. This
must be the result from a call to \code{\link[furrr:furrr_options]{furrr_options()}}.}

\item{.y}{A vector the same length as \code{.x}.
Vectors of length 1 will be recycled.}

\item{.l}{A list of vectors, such as a data frame.
The length of .l determines the number of arguments that .f will be called
with.
List names will be used if present.}
}
\value{
Equivalent to \code{\link[=map_vec]{map_vec()}}, \code{\link[=map2_vec]{map2_vec()}}, \code{\link[=pmap_vec]{pmap_vec()}},
\code{\link[=imap_vec]{imap_vec()}} and \code{\link[=xmap_vec]{xmap_vec()}}
}
\description{
These functions work exactly the same as \code{\link[=map_vec]{map_vec()}}, \code{\link[=map2_vec]{map2_vec()}},
\code{\link[=pmap_vec]{pmap_vec()}}, \code{\link[=imap_vec]{imap_vec()}} and \code{\link[=xmap_vec]{xmap_vec()}},
but allow you to map in parallel.
}
\examples{
fruits   <- c("apple", "banana", "carrot", "durian", "eggplant")
desserts <- c("bread", "cake", "cupcake", "streudel", "muffin")
x        <- sample(5)
y        <- sample(5)
z        <- sample(5)
names(z) <- fruits

future_map_vec(x, ~ . ^ 2)
future_map_vec(fruits, paste0, "s")

future_map2_vec(x, y, ~ .x + .y)
future_map2_vec(fruits, desserts, paste)

future_pmap_vec(list(x, y, z), sum)
future_pmap_vec(list(x, fruits, desserts), paste)

future_imap_vec(x, ~ .x + .y)
future_imap_vec(x, ~ paste0(.y, ": ", .x))
future_imap_vec(z, paste)

future_xmap_vec(list(x, y), ~ .x * .y)
future_xmap_vec(list(fruits, desserts), paste)
}
\seealso{
The original functions: \code{\link[furrr:future_map]{furrr::future_map()}},
\code{\link[furrr:future_map2]{furrr::future_map2()}}, \code{\link[furrr:future_map2]{furrr::future_pmap()}}, \code{\link[furrr:future_imap]{furrr::future_imap()}}
and \code{\link[=future_xmap]{future_xmap()}}

Non-parallelized equivalents: \code{\link[=map_vec]{map_vec()}}, \code{\link[=map2_vec]{map2_vec()}},
\code{\link[=pmap_vec]{pmap_vec()}}, \code{\link[=imap_vec]{imap_vec()}} and \code{\link[=xmap_vec]{xmap_vec()}}
}
