% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulations-validity.R
\name{v_general_simulations}
\alias{v_general_simulations}
\alias{v_simulations}
\alias{v_dual_simulations}
\alias{v_da_simulations}
\title{Internal Helper Functions for Validation of \code{\link{GeneralSimulations}} Objects}
\usage{
v_general_simulations(object)

v_simulations(object)

v_dual_simulations(object)

v_da_simulations(object)
}
\arguments{
\item{object}{(\code{GeneralSimulations})\cr object to validate.}
}
\value{
A \code{character} vector with the validation failure messages,
or \code{TRUE} in case validation passes.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

These functions are only used internally to validate the format of an input
\code{\link{GeneralSimulations}} or inherited classes and therefore not exported.
}
\section{Functions}{
\itemize{
\item \code{v_general_simulations()}: validates that the \code{\link{GeneralSimulations}} object
contains valid \code{data} object and valid \code{dose} simulations.

\item \code{v_simulations()}: validates that the \code{\link{Simulations}} object
contains valid object \code{fit}, \code{stop_reasons}, \code{stop_report}, and
\code{additional_stats} compared to the general class \code{\link{GeneralSimulations}}.

\item \code{v_dual_simulations()}: validates that the \code{\link{DualSimulations}} object and
capture the dose-biomarker \code{fits}, and the \code{sigma2W} and \code{rho} estimates.

\item \code{v_da_simulations()}: validates that the \code{\link{DASimulations}} object
contains valid \code{trial_duration} the vector of trial duration values for all
simulations.

}}
