% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rules-class.R
\docType{class}
\name{StoppingAll-class}
\alias{StoppingAll-class}
\alias{.StoppingAll}
\alias{StoppingAll}
\alias{.DefaultStoppingAll}
\title{\code{StoppingAll}}
\usage{
StoppingAll(stop_list, report_label = NA_character_)

.DefaultStoppingAll()
}
\arguments{
\item{stop_list}{(\code{list})\cr see slot definition.}

\item{report_label}{(\code{string}) \cr see slot definition.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{\link{StoppingAll}} is the class for testing a stopping rule that consists of
many single stopping rules that are in turn the objects of class \code{Stopping}.
All single stopping rules must be satisfied in order the result of this rule
to be \code{TRUE}.
}
\section{Slots}{

\describe{
\item{\code{stop_list}}{(\code{list})\cr list of stopping rules.}

\item{\code{report_label}}{label for reporting}
}}

\note{
Typically, end users will not use the \code{.DefaultStoppingAll()} function.
}
\examples{
# Define some stopping rules.
my_stopping1 <- StoppingMinCohorts(nCohorts = 3)
my_stopping2 <- StoppingTargetProb(target = c(0.2, 0.35), prob = 0.5)
my_stopping3 <- StoppingMinPatients(nPatients = 20)

# Create a list of stopping rules (of class `StoppingAll`) which would then be
# summarized by the `all` function, meaning that the study would be stopped only
# if all of the single stopping rules are `TRUE`.
my_stopping <- StoppingAll(
  stop_list = c(my_stopping1, my_stopping2, my_stopping3)
)
}
