% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rules-class.R
\docType{class}
\name{NextBestProbMTDMinDist-class}
\alias{NextBestProbMTDMinDist-class}
\alias{.NextBestProbMTDMinDist}
\alias{NextBestProbMTDMinDist}
\alias{.DefaultNextBestProbMTDMinDist}
\title{\code{NextBestProbMTDMinDist}}
\usage{
NextBestProbMTDMinDist(target)

.DefaultNextBestProbMTDMinDist()
}
\arguments{
\item{target}{(\code{numeric})\cr see slot definition.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{\link{NextBestProbMTDMinDist}} is the class of finding a next best dose that selects
the dose with the highest probability of having a toxicity rate with the
smallest distance to the toxicity target.
The dose is determined by calculating the posterior toxicity probability
for each dose per iteration and select the dose that has the smallest toxicity
probability distance to the target. The dose with the highest frequency
of being selected as MTD across iterations is the next best dose. Placebo
is not considered as the next dose and for that reason not used in
calculations. I.e. for placebo the toxicity probability distance to target
is not calculated and taken into account for determination of the next dose.
}
\section{Slots}{

\describe{
\item{\code{target}}{(\code{numeric})\cr the target toxicity probability.}
}}

\note{
Typically, end users will not use the \code{.DefaultNextBestProbMTDMinDist()} function.
}
\examples{
# In the example below, the MTD is defined as the dose with the highest
# probability of having a toxicity rate with minimal distance
# to the target of 30\%.
next_best_prob_mtd_min_dist <- NextBestProbMTDMinDist(target = 0.3)
}
