% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_monitor_sge.R
\name{crew_class_monitor_sge}
\alias{crew_class_monitor_sge}
\title{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} SGE monitor class}
\description{
SGE monitor \code{R6} class
}
\details{
See \code{\link[=crew_monitor_sge]{crew_monitor_sge()}}.
}
\seealso{
Other monitor: 
\code{\link{crew_monitor_sge}()}
}
\concept{monitor}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{verbose}}{See \code{\link[=crew_monitor_sge]{crew_monitor_sge()}}.}

\item{\code{command_list}}{See \code{\link[=crew_monitor_sge]{crew_monitor_sge()}}.}

\item{\code{command_terminate}}{See \code{\link[=crew_monitor_sge]{crew_monitor_sge()}}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-crew_class_monitor_sge-new}{\code{crew_class_monitor_sge$new()}}
\item \href{#method-crew_class_monitor_sge-validate}{\code{crew_class_monitor_sge$validate()}}
\item \href{#method-crew_class_monitor_sge-jobs}{\code{crew_class_monitor_sge$jobs()}}
\item \href{#method-crew_class_monitor_sge-terminate}{\code{crew_class_monitor_sge$terminate()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_monitor_sge-new"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_monitor_sge-new}{}}}
\subsection{Method \code{new()}}{
SGE monitor constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_monitor_sge$new(
  verbose = NULL,
  command_list = NULL,
  command_terminate = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{verbose}}{See \code{\link[=crew_monitor_sge]{crew_monitor_sge()}}.}

\item{\code{command_list}}{See \code{\link[=crew_monitor_sge]{crew_monitor_sge()}}.}

\item{\code{command_terminate}}{See \code{\link[=crew_monitor_sge]{crew_monitor_sge()}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an SGE monitor object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_monitor_sge-validate"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_monitor_sge-validate}{}}}
\subsection{Method \code{validate()}}{
Validate the monitor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_monitor_sge$validate()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_monitor_sge-jobs"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_monitor_sge-jobs}{}}}
\subsection{Method \code{jobs()}}{
List SGE jobs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_monitor_sge$jobs(user = ps::ps_username())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{user}}{Character of length 1, user name of the jobs to list.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{tibble} with one row per SGE job and columns with
specific details.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_monitor_sge-terminate"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_monitor_sge-terminate}{}}}
\subsection{Method \code{terminate()}}{
Terminate one or more SGE jobs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_monitor_sge$terminate(jobs = NULL, all = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{jobs}}{Character vector of job names or job IDs to terminate.
Ignored if \code{all} is set to \code{TRUE}.}

\item{\code{all}}{Logical of length 1, whether to terminate all the jobs
under your user name. This terminates ALL your SGE jobs,
regardless of whether \code{crew.cluster} launched them,
so use with caution!}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
}
