% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_launcher_aws_batch.R
\name{crew_class_launcher_aws_batch}
\alias{crew_class_launcher_aws_batch}
\title{AWS Batch launcher class}
\description{
AWS Batch launcher \code{R6} class
}
\details{
See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.
}
\section{IAM policies}{

In order for the AWS Batch \code{crew} plugin to function properly, your IAM
policy needs permission to perform the \code{SubmitJob} and \code{TerminateJob}
AWS Batch API calls. For more information on AWS policies and permissions,
please visit
\url{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html}.
}

\section{AWS arguments}{

The AWS Batch controller and launcher accept many arguments
which start with \code{"aws_batch_"}. These arguments are AWS-Batch-specific
parameters forwarded directly to the \code{submit_job()} method for
the Batch client in the \code{paws.compute} R package

For a full description
of each argument, including its meaning and format, please visit
\url{https://www.paws-r-sdk.com/docs/batch_submit_job/}. The upstream API
documentation is at
\url{https://docs.aws.amazon.com/batch/latest/APIReference/API_SubmitJob.html}
and the analogous CLI documentation is at
\url{https://docs.aws.amazon.com/cli/latest/reference/batch/submit-job.html}.

The actual argument names may vary slightly, depending
on which : for example, the \code{aws_batch_job_definition} argument of
the \code{crew} AWS Batch launcher/controller corresponds to the
\code{jobDefinition} argument of the web API and
\code{paws.compute::batch()$submit_job()}, and both correspond to the
\code{--job-definition} argument of the CLI.
}

\section{Verbosity}{

Control verbosity with the \code{paws.log_level} global option in R.
Set to 0 for minimum verbosity and 3 for maximum verbosity.
}

\seealso{
Other plugin_aws_batch: 
\code{\link{crew_controller_aws_batch}()},
\code{\link{crew_launcher_aws_batch}()}
}
\concept{plugin_aws_batch}
\section{Super class}{
\code{\link[crew:crew_class_launcher]{crew::crew_class_launcher}} -> \code{crew_class_launcher_aws_batch}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{options_aws_batch}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-crew_class_launcher_aws_batch-new}{\code{crew_class_launcher_aws_batch$new()}}
\item \href{#method-crew_class_launcher_aws_batch-validate}{\code{crew_class_launcher_aws_batch$validate()}}
\item \href{#method-crew_class_launcher_aws_batch-launch_worker}{\code{crew_class_launcher_aws_batch$launch_worker()}}
\item \href{#method-crew_class_launcher_aws_batch-terminate_worker}{\code{crew_class_launcher_aws_batch$terminate_worker()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="call"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-call'><code>crew::crew_class_launcher$call()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="crashes"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-crashes'><code>crew::crew_class_launcher$crashes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="launch"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-launch'><code>crew::crew_class_launcher$launch()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="poll"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-poll'><code>crew::crew_class_launcher$poll()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="resolve"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-resolve'><code>crew::crew_class_launcher$resolve()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="scale"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-scale'><code>crew::crew_class_launcher$scale()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="set_name"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-set_name'><code>crew::crew_class_launcher$set_name()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="settings"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-settings'><code>crew::crew_class_launcher$settings()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="start"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-start'><code>crew::crew_class_launcher$start()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="terminate"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-terminate'><code>crew::crew_class_launcher$terminate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="terminate_workers"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-terminate_workers'><code>crew::crew_class_launcher$terminate_workers()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="update"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-update'><code>crew::crew_class_launcher$update()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher_aws_batch-new"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher_aws_batch-new}{}}}
\subsection{Method \code{new()}}{
Abstract launcher constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher_aws_batch$new(
  name = NULL,
  workers = NULL,
  seconds_interval = NULL,
  seconds_timeout = NULL,
  seconds_launch = NULL,
  seconds_idle = NULL,
  seconds_wall = NULL,
  tasks_max = NULL,
  tasks_timers = NULL,
  reset_globals = NULL,
  reset_packages = NULL,
  reset_options = NULL,
  garbage_collection = NULL,
  tls = NULL,
  processes = NULL,
  r_arguments = NULL,
  options_metrics = NULL,
  options_aws_batch = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{workers}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{seconds_interval}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{seconds_timeout}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{seconds_launch}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{seconds_idle}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{seconds_wall}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{tasks_max}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{tasks_timers}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{reset_globals}}{Deprecated. See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{reset_packages}}{Deprecated. See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{reset_options}}{Deprecated. See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{garbage_collection}}{Deprecated. See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{tls}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{processes}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{r_arguments}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{options_metrics}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}

\item{\code{options_aws_batch}}{See \code{\link[=crew_launcher_aws_batch]{crew_launcher_aws_batch()}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An abstract launcher object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher_aws_batch-validate"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher_aws_batch-validate}{}}}
\subsection{Method \code{validate()}}{
Validate the launcher.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher_aws_batch$validate()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{NULL} (invisibly). Throws an error if a field is invalid.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher_aws_batch-launch_worker"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher_aws_batch-launch_worker}{}}}
\subsection{Method \code{launch_worker()}}{
Launch a local process worker which will
dial into a socket.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher_aws_batch$launch_worker(call, name, launcher, worker)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{call}}{Character string, a namespaced call to
\code{\link[crew:crew_worker]{crew::crew_worker()}}
which will run in the worker and accept tasks.}

\item{\code{name}}{Character string, an informative worker name.}

\item{\code{launcher}}{Character string, name of the launcher.}

\item{\code{worker}}{Character string, name of the worker instance.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
The \code{call} argument is R code that will run to
initiate the worker.
}

\subsection{Returns}{
A handle object to allow the termination of the worker
later on.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher_aws_batch-terminate_worker"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher_aws_batch-terminate_worker}{}}}
\subsection{Method \code{terminate_worker()}}{
Terminate a local process worker.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher_aws_batch$terminate_worker(handle)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{handle}}{A process handle object previously
returned by \code{launch_worker()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
}
