% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_process_tools.R
\name{train_test_split}
\alias{train_test_split}
\title{Train-Test-Split}
\usage{
train_test_split(dat, prop = 0.7, split_type = c("Random", "OOT",
  "byRow"), occur_time = NULL, cut_date = NULL, start_date = NULL,
  save_data = FALSE, dir_path = tempdir(), file_name = NULL,
  note = FALSE, seed = 43)
}
\arguments{
\item{dat}{A data.frame with independent variables and target variable.}

\item{prop}{The percentage of train data samples after the partition.}

\item{split_type}{Methods for partition.
\itemize{
  \item "Random" is to split train & test set randomly.
  \item "OOT" is to split by time for observation over time test.
  \item "byRow" is to split by rownumbers.
}}

\item{occur_time}{The name of the variable that represents the time at which each observation takes place. It is used for "OOT" split.}

\item{cut_date}{Time points for spliting data sets, e.g. : spliting Actual and Expected data sets.}

\item{start_date}{The earliest occurrence time of observations.}

\item{save_data}{Logical, save results in locally specified folder. Default is FALSE.}

\item{dir_path}{The path for periodically saved data file. Default is "./data".}

\item{file_name}{The name for periodically saved data file. Default is "dat".}

\item{note}{Logical. Outputs info. Default is TRUE.}

\item{seed}{Random number seed. Default is 46.}
}
\value{
A list of indices (train-test)
}
\description{
\code{train_test_split} Functions for partition of data.
}
\examples{
train_test <- train_test_split(lendingclub,
split_type = "OOT", prop = 0.7,
occur_time = "issue_d", seed = 12, save_data = FALSE)
dat_train = train_test$train
dat_test = train_test$test
}
