% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_transformation.R
\name{merge_category}
\alias{merge_category}
\title{Merge Category}
\usage{
merge_category(dat, ex_cols = "date$|id$|time$|DATA$|ID$|TIME$",
  p = 0.01, m = 10, note = FALSE)
}
\arguments{
\item{dat}{A data frame with x and target.}

\item{ex_cols}{A list of excluded variables. Default is NULL.}

\item{p}{The minimum percent of samples in a category to merge.}

\item{m}{The minimum number of categories.}

\item{note}{Logical, outputs info. Default is TRUE.}
}
\value{
A data.frame with merged category variables.
}
\description{
\code{merge_category} is  for merging   category of nominal variables which number of categories is more than m or percent of samples in any categories is less than p.
}
\examples{
#merge_catagory
dat =  merge_category(lendingclub,ex_cols = "id$|_d$")
char_list = get_names(dat = dat,types = c('factor', 'character'),
ex_cols = "id$|_d$", get_ex = FALSE)
str(dat[,char_list])
}
