% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_filter_high_cor.R
\name{fast_high_cor_filter}
\alias{fast_high_cor_filter}
\alias{high_cor_filter}
\title{high_cor_filter}
\usage{
fast_high_cor_filter(dat, p = 0.7, x_list = NULL, com_list = NULL,
  ex_cols = NULL, save_data = FALSE, cor_class = TRUE,
  parallel = FALSE, note = FALSE, file_name = NULL,
  dir_path = tempdir(), ...)

high_cor_filter(dat, com_list = NULL, x_list = NULL, ex_cols = NULL,
  onehot = TRUE, parallel = TRUE, p = 0.7, file_name = NULL,
  dir_path = tempdir(), save_data = FALSE, note = FALSE, ...)
}
\arguments{
\item{dat}{A data.frame with independent variables.}

\item{p}{Threshold of correlation between features. Default is 0.7.}

\item{x_list}{Names of independent variables.}

\item{com_list}{A data.frame with important values of each variable. eg : IV_list}

\item{ex_cols}{A list of excluded variables. Regular expressions can also be used to match variable names. Default is NULL.}

\item{save_data}{Logical, save results in locally specified folder. Default is FALSE}

\item{cor_class}{Culculate catagery variables's correlation matrix. Default is FALSE.}

\item{parallel}{Logical, parallel computing. Default is FALSE.}

\item{note}{Logical. Outputs info. Default is TRUE.}

\item{file_name}{The name for periodically saved results files. Default is "Feature_selected_COR".}

\item{dir_path}{The path for periodically saved results files. Default is "./variable".}

\item{...}{Additional parameters.}

\item{onehot}{one-hot-encoding independent variables.}
}
\value{
A list of selected variables.
}
\description{
\code{fast_high_cor_filter} In a highly correlated variable group, select the  variable with the highest IV.
\code{high_cor_filter} In a highly correlated variable group, select the  variable with the highest IV.
}
\examples{
# calculate iv for each variable.
iv_list = feature_select_wrapper(dat_train = UCICreditCard[1:1000,], dat_test = NULL,
target = "default.payment.next.month",
occur_time = "apply_date",
filter = c("IV"), cv_folds = 1, iv_cp = 0.01,
ex_cols = "ID$|date$|default.payment.next.month$",
save_data = FALSE, vars_name = FALSE)
fast_high_cor_filter(dat = UCICreditCard[1:1000,],
com_list = iv_list, save_data = FALSE,
ex_cols = "ID$|date$|default.payment.next.month$",
p = 0.9, cor_class = FALSE ,var_name = FALSE)
}
\seealso{
\code{\link{get_correlation_group}}, \code{\link{reduce_high_cor}}, \code{\link{char_cor_vars}}
}
