% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{confint_search}
\alias{confint_search}
\title{Confidence interval search procedure}
\usage{
confint_search(
  start,
  b,
  n,
  nmodel,
  Xnull_,
  y,
  tr_,
  new_tr_mat,
  invS,
  family,
  family2,
  Z,
  type,
  nsteps = 1000L,
  weight = TRUE,
  alpha = 0.05,
  verbose = TRUE
)
}
\arguments{
\item{start}{Numeric value indicating the starting value for the search procedure}

\item{b}{Numeric value indicating the parameter estimate}

\item{n}{Integer indicating the sample size}

\item{nmodel}{Integer. The number of models}

\item{Xnull_}{Numeric matrix. The covariate design matrix with the treatment variable removed}

\item{y}{Numeric vector of response variables}

\item{tr_}{Numeric vector. The original random allocation (0s and 1s)}

\item{new_tr_mat}{A matrix. Each column is a new random treatment allocation with 1s (treatment group) and 0s (control group)}

\item{invS}{A matrix. If using the weighted statistic then it should be the inverse covariance matrix of the observations}

\item{family}{A \link{stats}\link{family} object}

\item{family2}{A string naming the link function}

\item{Z}{Matrix. Random effects design matrix describing cluster membership}

\item{type}{String. Either "rw" for Romano-Wolf, "b" or "br" for bonferroni, "h" or "hr" for Holm, or "none"}

\item{nsteps}{Integer specifying the number of steps of the search procedure}

\item{weight}{Logical indicating whether to use the weighted (TRUE) or unweighted (FALSE) test statistic}

\item{alpha}{The function generates (1-alpha)*100\% confidence intervals. Default is 0.05.}

\item{verbose}{Logical indicating whether to provide detailed output.}
}
\value{
The estimated confidence interval bound
}
\description{
Search for the bound of a confidence interval using permutation test statistics
}
