% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stepdown.R
\name{stepdown}
\alias{stepdown}
\title{Conduct the randomisation-based stepdown procedure}
\usage{
stepdown(
  fitlist,
  tr_var = "treat",
  cl_var = "cl",
  data,
  alpha = 0.05,
  plots = TRUE,
  n_permute = 1000,
  nsteps = 1000,
  rand_func = NULL,
  confint = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{fitlist}{A list of models fitted with lme4. All models should be fit using the
same data frame.}

\item{tr_var}{String indicating the name of the column in data that is a binary indicator
for whether the observation was under the treatment (1=treatment, 0=control)}

\item{cl_var}{String specifying the name of the column identifying the clusters/cluster-time}

\item{data}{A data frame containing the data used to fit the models in fitlist}

\item{alpha}{Numeric. 100(1-alpha)\% confidence intervals are calculated. Default it 0.05}

\item{plots}{Logical indicating whether to plot permutational distributions and confidence
interval search during running of function. Default is TRUE}

\item{n_permute}{Number of permutations of the randomisation test to run}

\item{nsteps}{Number of steps of the confidence interval search process}

\item{rand_func}{String of the name of a function that re-randomises the clusters. The function should
produce a data frame that identifies the clusters in the treatment group under the new
randomisation scheme. The data frame can either have a single column with name cl_var or
two columns of cl_var and t identifying the cluster ID and time period a cluster joins
the treatment group. If NULL then clusters are randomised in a 1:1 ratio to treatment and control}

\item{confint}{Logical indicating whether to run the confidence interval search process}

\item{verbose}{Logical indicating whether to provide detailed output}
}
\value{
A data frame with the point estimates, p-values, and confidence intervals
}
\description{
For a set of models fit with lme4, the function will conduct the randomisation tests
and generate p-values for the null hypotheses of no treatment effect that controls the
family-wise error rate, and generates a 100(1-alpha)\% confidence set for the
treatment effect model parameters.
}
\examples{
out <- twoarm_sim()
data <- out[[1]]
  fit1 <- lme4::glmer(y1 ~ treat + (1|cl) ,
data=data,
family="poisson")

fit2 <- lme4::glmer(y2 ~ treat + (1|cl),
                    data=data,
                    family="poisson")
 stepdown(fitlist=list(fit1,fit2),
          data=data,
          n_permute = 100,
          nsteps=100,
          plots=FALSE,
          verbose=TRUE)
}
