% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/location_search.R
\name{cqc_locations_search}
\alias{cqc_locations_search}
\title{Location Queries}
\usage{
cqc_locations_search(care_home = NULL, onspd_ccg_code = NULL,
  onspd_ccg_name = NULL, ods_ccg_code = NULL, ods_ccg_name = NULL,
  gac_service_type_description = NULL, constituency = NULL,
  local_authority = NULL, inspection_directorate = NULL,
  primary_inspection_category_code = NULL,
  primary_inspection_category_name = NULL,
  non_primary_inspection_category_code = NULL,
  non_primary_inspection_category_name = NULL, overall_rating = NULL,
  region = NULL, regulated_activity = NULL, report_type = NULL,
  verbose = TRUE, clean_names = TRUE)
}
\arguments{
\item{care_home}{If \code{TRUE}, only returns care homes. If \code{FALSE}, returns
all locations except care homes. Defaults to \code{NULL} and returns all
locations including care homes.}

\item{onspd_ccg_code}{Include only locations where the ONSPD CCG code
of the geographic area covering the Location's postcode matches one of
the values of this parameter.}

\item{onspd_ccg_name}{Include only locations where the ONSPD CCG name
of the geographic area covering the Location's postcode matches one of the
values of this parameter.}

\item{ods_ccg_code}{Include only locations where the ODS code of the CCG
selected by this organisation is known and matches one of the values of
this parameter.}

\item{ods_ccg_name}{Include only locations where the ODS name of the CCG
selected by this organisation is known and matches one of the values of
this parameter.}

\item{gac_service_type_description}{GAC Service Type Descriptions,
matching one or more values of this parameter.
e.g. "Acute services with overnight beds".}

\item{constituency}{Location is in a given parliamentary constituency}

\item{local_authority}{Location is in a given local authority.}

\item{inspection_directorate}{The type of inspection directorate. Accepts
one or more off "Adult social care", "Hospitals",
"Primary medical services" or "Unspecified".}

\item{primary_inspection_category_code}{The primary inspection
category code. e.g. "H1"}

\item{primary_inspection_category_name}{The primary inspection
category name. e.g. "Slimming Clinics"}

\item{non_primary_inspection_category_code}{The non-primary inspection
category code. e.g. "H1"}

\item{non_primary_inspection_category_name}{The non-primary inspection
category name. e.g. "Slimming Clinics".}

\item{overall_rating}{Include only locations with a given inspection rating.
e.g. "Good". Accepts character vector of multiple inspection ratings.}

\item{region}{Region of the UK, e.g. "London" or "North East".}

\item{regulated_activity}{The type of activity at a location, e.g.
"Accommodation for persons who require treatment for substance misuse".}

\item{report_type}{The type of report, e.g. "Location", "Provider"
or "CoreService".}

\item{verbose}{If \code{TRUE} prints download progress to console if requesting
more than 1,000 records. Defaults to \code{TRUE}.}

\item{clean_names}{If \code{TRUE}, converts a column names to snake_case.
Defaults to \code{TRUE}.}
}
\value{
A tibble with the location ID, name and postcode of all locations
meeting the given parameters.
}
\description{
Returns all available locations, subject to given parameters.
}
\details{
All parameters except \code{care_home}, \code{verbose} and \code{clean_names}
accept an array of values, and will return locations matching any of the
values of those arrays, subject to other parameters. Search parameters are
case sensitive, e.g. "hospitals"
}
\examples{
\donttest{
## Get all care homes in Redbridge
loc1 <- cqc_locations_search(care_home = TRUE, local_authority = "Redbridge")
}
}
