% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cp_diagnostics.R
\name{cp_value}
\alias{cp_value}
\alias{cp_diff}
\title{Control Polygon Diagnostics}
\usage{
cp_value(obj, x)

cp_diff(cp1, cp2)
}
\arguments{
\item{obj}{a cpr_cp object or \code{data.frame} where the first column is the
abscissa and the second column is the ordinate for the control polygon vertices.}

\item{x}{absicissa at which to determine the ordinate on control polygon cp}

\item{cp1}{a cpr_cp object}

\item{cp2}{a cpr_cp object}
}
\value{
\code{cp_value} returns the ordinate on the control polygon line segment for
the abscissae \code{x} given.  \code{x} could be a control vertex or on a
line segment defined by two control vertices of the control polygon
provided.

\code{cp_diff} returns the absolute vertical distance between the control
vertices of cp1 to the control polygon cp2.
}
\description{
Collection of functions for inspection and analysis of the control polygons
}
\author{
Peter DeWitt \email{dewittpe@gmail.com}
}
