% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set.R
\name{cpp_set}
\alias{cpp_set}
\title{Create set}
\usage{
cpp_set(x)
}
\arguments{
\item{x}{An integer, numeric, character, or logical vector.}
}
\value{
Returns a CppSet object referencing a set in C++.
}
\description{
Create a set. Sets are containers of unique, sorted elements.
}
\details{
Sets are associative containers. They do not provide random access through an index. I.e., \code{s[2]} does not return the second element.

C++ set methods implemented in this package are \link{clear}, \link{contains}, \link{count}, \link{emplace}, \link{empty}, \link{erase}, \link{insert}, 
\link{max_size}, \link{merge}, and \link{size}. The package also adds the \link{==} operator and various helper functions (\link{print}, \link{to_r}, 
\link{type}).

All object-creating methods in this package begin with \code{cpp_} to avoid clashes with functions from other packages, such as \code{utils::stack} and 
\code{base::vector}.
}
\examples{
s <- cpp_set(6:9)
s
# 6 7 8 9

insert(s, 4:7)
s
# 4 5 6 7 8 9

print(s, from = 6)
# 6 7 8 9

s <- cpp_set(c("world", "hello", "there"))
s
# "hello" "there" "world"

erase(s, "there")
s
# "hello" "world"

}
\seealso{
\link{cpp_unordered_set}, \link{cpp_multiset}, \link{cpp_unordered_multiset}.
}
