% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/source.R
\name{cpp_source}
\alias{cpp_source}
\alias{cpp_function}
\alias{cpp_eval}
\title{Compile C++ code}
\usage{
cpp_source(file, code = NULL, env = parent.frame(), clean = TRUE, quiet = TRUE)

cpp_function(code, env = parent.frame(), clean = TRUE, quiet = TRUE)

cpp_eval(code, env = parent.frame(), clean = TRUE, quiet = TRUE)
}
\arguments{
\item{file}{A file containing C++ code to compile}

\item{code}{If non-null, the C++ code to compile}

\item{env}{The R environment where the R wrapping functions should be defined.}

\item{clean}{If \code{TRUE}, cleanup the files after sourcing}

\item{quiet}{If 'TRUE`, do not show compiler output}
}
\value{
For \code{\link[=cpp_source]{cpp_source()}} and \verb{[cpp_function()]} the results of
\code{\link[=dyn.load]{dyn.load()}} (invisibly). For \verb{[cpp_eval()]} the results of the evaluated
expression.
}
\description{
\code{\link[=cpp_source]{cpp_source()}} compiles and loads a single C++ file for use in R.
\code{\link[=cpp_function]{cpp_function()}} compiles and loads a single function for use in R.
\code{\link[=cpp_eval]{cpp_eval()}} evaluates a single C++ expression and returns the result.
}
\details{
Within C++ code you can use \verb{[[cpp11::linking_to("pkgxyz")]]} to link to
external packages. This is equivalent to putting those packages in the
\code{LinkingTo} field in a package DESCRIPTION.
}
\examples{
\dontrun{
cpp_source(
  code = '#include "cpp11/integers.hpp"

  [[cpp11::register]]
  int num_odd(cpp11::integers x) {
    int total = 0;
    for (int val : x) {
      if ((val \% 2) == 1) {
        ++total;
      }
    }
    return total;
  }
  ')

num_odd(as.integer(c(1:10, 15, 23)))

if (require("progress")) {

cpp_source(
  code = '
#include <cpp11/R.hpp>
#include <RProgress.h>

[[cpp11::linking_to("progress")]]

[[cpp11::register]] void
show_progress() {
  RProgress::RProgress pb("Downloading [:bar] ETA: :eta");

  pb.tick(0);
  for (int i = 0; i < 100; i++) {
    usleep(2.0 / 100 * 1000000);
    pb.tick();
  }
}
')

show_progress()
}
}
}
