% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.plot.R
\name{data.plot}
\alias{data.plot}
\title{Plot the histograms of simulated data}
\usage{
data.plot(data, xb, bins = 30)
}
\arguments{
\item{data}{A data frame of simulated duration data in which the duration variable is called y.
Generally, this data frame is taken from the \code{data} attribute of the \code{\link[coxed]{sim.survdata}}
function}

\item{xb}{A vector of the linear predictors, combining the covariates and coefficients from the simulation.
Generally, this data frame is taken from the \code{xb} attribute of the \code{\link[coxed]{sim.survdata}}
function}

\item{bins}{The number of bins to draw in each histogram}
}
\value{
A figure of class \code{"gg"} and \code{"ggplot"}
}
\description{
This function is called by \code{\link[coxed]{survsim.plot}} and is not intended to be used by itself.
}
\details{
This function produces three histograms, one of the simulated durations, one of the linear predictors,
and one of the exponentiated linear predictors. It uses \code{\link[ggplot2]{facet_wrap}} within
a call to \code{\link[ggplot2]{ggplot}} to arrange the plots.
}
\examples{
simdata <- sim.survdata(N=1000, T=100, num.data.frames=1)
data.plot(simdata$data, simdata$xb)
}
\seealso{
\code{\link[coxed]{survsim.plot}}, \code{\link[coxed]{sim.survdata}}
}
\author{
Jonathan Kropko <jkropko@virginia.edu> and Jeffrey J. Harden <jharden2@nd.edu>
}
