% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw.R
\docType{data}
\name{draw_grob}
\alias{draw_grob}
\alias{GeomDrawGrob}
\title{Draw a grob.}
\usage{
draw_grob(grob, x = 0, y = 0, width = 1, height = 1, scale = 1,
  clip = "inherit")
}
\arguments{
\item{grob}{The grob to place.}

\item{x}{The x location of the lower left corner of the grob.}

\item{y}{The y location of the lower left corner of the grob.}

\item{width}{Width of the grob.}

\item{height}{Height of the grob.}

\item{scale}{Scales the grob relative to the rectangle defined by \code{x}, \code{y}, \code{width}, \code{height}. A setting
of \code{scale = 1} indicates no scaling.}

\item{clip}{Set to "on" to clip the grob or "inherit" to not clip. Note that clipping doesn't always work as
expected, due to limitations of the grid graphics system.}
}
\description{
Places an arbitrary grob somewhere onto the drawing canvas. By default, coordinates run from
0 to 1, and the point (0, 0) is in the lower left corner of the canvas.
}
\examples{
# A grid grob (here a blue circle)
library(grid)
g <- circleGrob(gp = gpar(fill = "blue"))
# place into the middle of the plotting area, at a scale of 50\%
ggdraw() + draw_grob(g, scale = 0.5)
}
\keyword{datasets}
