% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_results.R
\name{time_series_map}
\alias{time_series_map}
\title{Function maps time series flood data, either by gage or by county}
\usage{
time_series_map(flood_stats, category = "minor", filename = "")
}
\arguments{
\item{flood_stats}{Either a data frame of flood analysis results, by gage or by county,
or a list of both data frames.}

\item{category}{Character string of the flood magnitude category to be used
for mapping (one of "minor", "moderate", "major", or "extreme"). This
parameter only works when mapping county-level, rather than gage-level,
values.}

\item{filename}{Character string of the file path and beginning of name of where
to save the individual images generated. For example, "C:/Desktop/TX" would produce
image files saved as "TX_Gage_Map_Date.png" or "TX_County_Map_Date.png" where
"Date" is replaced by the actual date. If no filename is provided, the images
aren't saved but are displayed in the plot viewer.}
}
\value{
For each date with data, a map of the state(s) analyzed showing counties
  and gages color coded based on flood magnitude, depending on the type of data
  in flood_stats. Gage flood thresholds are "None" (flood_ratio < 1), "Minor"
  (flood_ratio < 1.5), "Moderate" (flood_ratio < 2), "Major" (flood_ratio < 5),
  and "Extreme" (flood_ratio > 5). For county aggregate maps, flood exposure
  is assessed based on the percentage of gages in the county at or above a specified
  flood threshold. Exposure categories include "Low" (0% - 20%), "Moderate"
  (20% - 40%), "Moderate-High" (40% - 60%), "High" (60% - 80%), and "very High"
  (80% - 100%).
}
\description{
Displays a state or multi-state map summarizing flood analysis results either
by gage or county for each individual date with data.
}
\examples{
\dontrun{
#Use the time_series_flood function with option filter_data = FALSE to get data
  tx <- time_series_flood(state = "Texas", start_date = "2017-08-24", end_date =
        "2017-09-10", filter_data = FALSE)

#Returns a list of gage data and county data. Can map them individually or all at once
}
}
