% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countland_score.R
\name{ScoreCells}
\alias{ScoreCells}
\title{Calculate several scores for counts across cells}
\usage{
ScoreCells(C, gene_string = NULL)
}
\arguments{
\item{C}{countland object}

\item{gene_string}{string with regular expression expression matching gene names of interest (default=NULL)}
}
\value{
countland object with slot cell_scores
}
\description{
Calculate several scores for counts across cells
}
\examples{
gold_path <- system.file("testdata", package = "countland", mustWork = TRUE)
gold.data <- Seurat::Read10X(data.dir = gold_path)
C <- countland(gold.data)
C <- ScoreCells(C,gene_string="*149932$")
}
