% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countgmifs.R
\name{countgmifs}
\alias{countgmifs}
\title{Discrete Response Generalized Monotone Incremental Forward Stagewise Regression.}
\usage{
countgmifs(formula, data, x = NULL, offset, subset, epsilon = 0.001,
  tol = 1e-05, scale = TRUE, verbose = FALSE, family = "nb", ...)
}
\arguments{
\item{formula}{an object of class "\code{formula}" (or one that can be coerced to that class): a symbolic description of the model to be fitted. The left side of the formula is the ordinal outcome while the variables on the right side of the formula are the covariates that are not included in the penalization process. Note that if all variables in the model are to be penalized, an intercept only model formula should be specified.}

\item{data}{an optional data frame, list or environment (or object coercible by \code{as.data.frame} to a data frame) containing the variables in the model.}

\item{x}{an optional matrix of predictors that are to be penalized in the model fitting process.}

\item{offset}{this can be used to specify an a priori known component to be included during fitting (e.g., denominator term). This should be NULL or a numeric vector of length equal to the number of cases.}

\item{subset}{an optional vector specifying a subset of observations to be used in the fitting process.}

\item{epsilon}{small incremental amount used to update a coefficient at a given step.}

\item{tol}{the iterative process stops when the difference between successive log-likelihoods is less than this specified level of tolerance.}

\item{scale}{logical, if TRUE (default) the penalized predictors are centered and scaled.}

\item{verbose}{logical, if TRUE the step number is printed to the console (default is FALSE).}

\item{family}{the type of count response model to be fit. Default is 'nb' for negative binomial; user can also specify 'poisson'.}

\item{...}{other arguments.}
}
\description{
This function can fit a Poisson or negative binomial model when the number of parameters exceeds the sample size, using the the generalized monotone incremental forward stagewise method.
}
\seealso{
See Also \code{\link{coef.countgmifs}}, \code{\link{summary.countgmifs}}, \code{\link{predict.countgmifs}}, \code{\link{plot.countgmifs}}
}
\examples{
set.seed(26)
n <- 50 # Sample size
p <- 500 # Number of covariates
intercept<- .5
#True parameter values for the 500 covariates
beta<- c(log(1.5), log(1.5), -log(1.5), -log(1.5), -log(1.5), rep(0,495)) 
alpha<- 0.5 # Intercept
x<- matrix(rnorm(n*p,0,1), nrow=n, ncol=p, byrow=TRUE) #Covariate values
colnames(x)<- paste("Var",1:p, sep="")  
mu<- exp(intercept + crossprod(t(x),beta))
y<- rnbinom(n=n, size=1/alpha ,mu=mu) # Discrete response
data<- data.frame(y,x)
nb<-countgmifs(y ~ 1 , data=data, offset=NULL, x=x, epsilon=0.01, tol=0.001, 
       scale=TRUE, verbose=FALSE)
coef.AIC<-coef(nb, model.select="AIC")
coef.AIC[coef.AIC!=0]
predict(nb, model.select="AIC")
plot(predict(nb, model.select="AIC"), y)
plot(nb)
}
\keyword{methods}
\keyword{regression}
