% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rovr.R
\name{predict.rovr}
\alias{predict.rovr}
\title{Predict method for Regression One-Vs-Rest}
\usage{
\method{predict}{rovr}(object, newdata, type = "class", ...)
}
\arguments{
\item{object}{An object of class `rovr` as output by function `regression.one.vs.rest`.}

\item{newdata}{New data on which to make predictions.}

\item{type}{One of "class" (will output the class with minimum expected cost) or "score"
(will output the predicted cost for each class, i.e. less is better).}

\item{...}{Additional arguments to pass to the predict method of the base regressor.}
}
\value{
When passing `type = "class"`, a vector with class numbers or names (if the cost matrix had them).
When passing `type = "score"`, will output a `data.frame` with the same number of columns as `C` (passed to
the `regression.one.vs.rest` function) and the predicted cost for each observation and class.
}
\description{
Predicts either class with expected minimum cost or the expected cost (less is better) for new data.
}
