#' Mutational signatures data from COSMIC, Catalogue Of Somatic Mutations In
#' Cancer (v3.1 - June 2020)
#'
#' @source \url{https://cancer.sanger.ac.uk/signatures/}.
#'
#' @format A list with one element \code{signature}, with the
#' same structure as \code{\link{signature}}.
#'
#' @inheritSection signature Remark
#'
#' @name COSMIC_v3.1
#'
#' @examples
#' sbs96_sig_v3.1 <- COSMIC_v3.1$signature$GRCh37$SBS96
#'
"COSMIC_v3.1"
