% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_to_cov.R
\name{cor_to_cov}
\alias{cor_to_cov}
\title{Convert a correlation to covariance}
\usage{
cor_to_cov(cor, sd = NULL, variance = NULL, tol = .Machine$double.eps^(2/3))
}
\arguments{
\item{cor}{A correlation matrix, or a partial or a semipartial correlation matrix.}

\item{sd, variance}{A vector that contains the standard deviations, or the variance, of the variables in the correlation matrix.}

\item{tol}{Relative tolerance to detect zero singular values.}
}
\value{
A covariance matrix.
}
\description{
Convert a correlation to covariance
}
\examples{
cor <- cor(iris[1:4])
cov(iris[1:4])

cor_to_cov(cor, sd = sapply(iris[1:4], sd))
cor_to_cov(cor, variance = sapply(iris[1:4], var))
}
