% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documentation_methods.r
\name{tCorpus$set}
\alias{tCorpus$set}
\alias{tCorpus$set_meta}
\alias{set}
\alias{set_meta}
\title{Modify the token and meta data.tables of a tCorpus}
\arguments{
\item{column}{Name of a new column (to create) or existing column (to transform)}

\item{value}{An expression to be evaluated within the token/meta data, or a vector of the same length as the number of rows in the data. Note that if a subset is used, the length of value should be the same as the length of the subset (the TRUE cases of the subset expression) or a single value.}

\item{subset}{logical expression indicating rows to keep in the tokens data or meta data}
}
\description{
Modify the token/meta data.table by setting the values of one (existing or new) column. The subset argument can be used to modify only subsets of columns, and can be a logical vector (select TRUE rows), numeric vector (indices of TRUE rows) or logical expression (e.g. pos == 'noun'). If a new column is made whie using a subset, then the rows outside of the selection are set to NA.
}
\details{
\strong{Usage:}

## R6 method for class tCorpus. Use as tc$method (where tc is a tCorpus object).

\preformatted{set(column, value, subset)}
\preformatted{set_meta(column, value, subset)}
}
\examples{
tc = create_tcorpus(sotu_texts, doc_column = 'id')

tc$get()  ## show original

## create new column
i <- 1:tc$n
tc$set(column = 'i', i)
## create new column based on existing column(s)
tc$set(column = 'token_upper', toupper(token))
## use subset to modify existing column
tc$set('token', paste0('***', token, '***'), subset = token_id == 1)
## use subset to create new column with NA's
tc$set('second_token', token, subset = token_id == 2)

tc$get()  ## show after set


##### use set for meta data with set_meta
tc$set_meta('party_pres', paste(party, president, sep=': '))
tc$get_meta()
}
