% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{cv.cornet}
\alias{cv.cornet}
\title{Performance measurement}
\usage{
cv.cornet(y, cutoff, X, alpha = 1, nfolds.ext = 5, nfolds.int = 10,
  foldid.ext = NULL, foldid.int = NULL, type.measure = "deviance",
  ...)
}
\arguments{
\item{y}{continuous outcome\strong{:}
vector of length \eqn{n}}

\item{cutoff}{cut-off point for dichotomising outcome into classes\strong{:}
\emph{meaningful} value between \code{min(y)} and \code{max(y)}}

\item{X}{features\strong{:}
numeric matrix with \eqn{n} rows (samples)
and \eqn{p} columns (variables)}

\item{alpha}{elastic net mixing parameter\strong{:}
numeric between \eqn{0} (ridge) and \eqn{1} (lasso)}

\item{nfolds.ext}{number of external folds}

\item{nfolds.int}{internal fold identifiers\strong{:}
vector of length \eqn{n} with entries
between \eqn{1} and \code{nfolds.int};
or \code{NULL}}

\item{foldid.ext}{external fold identifiers\strong{:}
vector of length \eqn{n} with entries
between \eqn{1} and \code{nfolds.ext};
or \code{NULL}}

\item{foldid.int}{number of internal folds}

\item{type.measure}{loss function for binary classification\strong{:}
character \code{"deviance"}, \code{"mse"}, \code{"mae"},
or \code{"class"} (see \code{\link[glmnet]{cv.glmnet}})}

\item{...}{further arguments passed to
\code{\link[cornet]{cornet}} or \code{\link[glmnet]{glmnet}}}
}
\description{
Compares models for a continuous response with a cut-off value.
}
\details{
Computes the cross-validated loss of logistic and combined regression.
}
\examples{
\dontshow{n <- 100; p <- 20
y <- rnorm(n)
X <- matrix(rnorm(n*p),nrow=n,ncol=p)
loss <- cv.cornet(y=y,cutoff=0,X=X,nfolds.ext=2)
loss}
\donttest{n <- 100; p <- 200
y <- rnorm(n)
X <- matrix(rnorm(n*p),nrow=n,ncol=p)
loss <- cv.cornet(y=y,cutoff=0,X=X)
loss}

}
