/*
 * Decompiled with CFR 0.152.
 */
package org.jamesframework.core.subset;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.jamesframework.core.exceptions.SolutionModificationException;
import org.jamesframework.core.problems.sol.Solution;

public class SubsetSolution
extends Solution {
    private final Set<Integer> selected;
    private final Set<Integer> selectedView;
    private final Set<Integer> unselected;
    private final Set<Integer> unselectedView;
    private final Set<Integer> all;
    private final Set<Integer> allView;
    private Comparator<Integer> orderOfIDs;

    public SubsetSolution(Set<Integer> allIDs) {
        this(allIDs, false);
    }

    public SubsetSolution(Set<Integer> allIDs, Set<Integer> selectedIDs) {
        this(allIDs, selectedIDs, false);
    }

    public SubsetSolution(Set<Integer> allIDs, boolean naturalOrder) {
        this(allIDs, naturalOrder ? Comparator.naturalOrder() : null);
    }

    public SubsetSolution(Set<Integer> allIDs, Set<Integer> selectedIDs, boolean naturalOrder) {
        this(allIDs, selectedIDs, naturalOrder ? Comparator.naturalOrder() : null);
    }

    public SubsetSolution(Set<Integer> allIDs, Comparator<Integer> orderOfIDs) {
        this(allIDs, Collections.emptySet(), orderOfIDs);
    }

    public SubsetSolution(Set<Integer> allIDs, Set<Integer> selectedIDs, Comparator<Integer> orderOfIDs) {
        this(allIDs, selectedIDs, orderOfIDs, true);
    }

    private SubsetSolution(Set<Integer> allIDs, Set<Integer> selectedIDs, Comparator<Integer> orderOfIDs, boolean checkInput) {
        if (checkInput) {
            if (allIDs == null) {
                throw new NullPointerException("Error when creating subset solution: set of all IDs can not be null.");
            }
            if (allIDs.stream().anyMatch(Objects::isNull)) {
                throw new NullPointerException("Error when creating subset solution: set of all IDs can not contain any null elements.");
            }
            if (allIDs.isEmpty()) {
                throw new IllegalArgumentException("Error when creating subset solution: set of all IDs can not be empty.");
            }
            if (selectedIDs == null) {
                throw new NullPointerException("Error when creating subset solution: set of selected IDs can not be null.");
            }
            if (selectedIDs.stream().anyMatch(Objects::isNull)) {
                throw new NullPointerException("Error when creating subset solution: set of selected IDs can not contain any null elements.");
            }
        }
        this.orderOfIDs = orderOfIDs;
        if (orderOfIDs == null) {
            this.all = new LinkedHashSet<Integer>(allIDs);
            this.selected = new LinkedHashSet<Integer>();
            this.unselected = new LinkedHashSet<Integer>(allIDs);
            this.allView = Collections.unmodifiableSet(this.all);
            this.selectedView = Collections.unmodifiableSet(this.selected);
            this.unselectedView = Collections.unmodifiableSet(this.unselected);
        } else {
            this.all = new TreeSet<Integer>(orderOfIDs);
            this.all.addAll(allIDs);
            this.selected = new TreeSet<Integer>(orderOfIDs);
            this.unselected = new TreeSet<Integer>(orderOfIDs);
            this.unselected.addAll(allIDs);
            this.allView = Collections.unmodifiableNavigableSet((TreeSet)this.all);
            this.selectedView = Collections.unmodifiableNavigableSet((TreeSet)this.selected);
            this.unselectedView = Collections.unmodifiableNavigableSet((TreeSet)this.unselected);
        }
        for (int ID : selectedIDs) {
            if (checkInput && !allIDs.contains(ID)) {
                throw new IllegalArgumentException("Error while creating subset solution: set of selected IDs should be a subset of set of all IDs.");
            }
            this.selected.add(ID);
            this.unselected.remove(ID);
        }
    }

    public SubsetSolution(SubsetSolution sol) {
        this(sol.getAllIDs(), sol.getSelectedIDs(), sol.getOrderOfIDs(), false);
    }

    @Override
    public SubsetSolution copy() {
        return new SubsetSolution(this);
    }

    public Comparator<Integer> getOrderOfIDs() {
        return this.orderOfIDs;
    }

    public boolean select(int ID) {
        if (!this.all.contains(ID)) {
            throw new SolutionModificationException("Error while modifying subset solution: unable to select ID " + ID + " (no entity with this ID).", (Solution)this);
        }
        if (this.selected.contains(ID)) {
            return false;
        }
        this.selected.add(ID);
        this.unselected.remove(ID);
        return true;
    }

    public boolean deselect(int ID) {
        if (!this.all.contains(ID)) {
            throw new SolutionModificationException("Error while modifying subset solution: unable to deselect ID " + ID + " (no entity with this ID).", (Solution)this);
        }
        if (!this.selected.contains(ID)) {
            return false;
        }
        this.selected.remove(ID);
        this.unselected.add(ID);
        return true;
    }

    public boolean selectAll(Collection<Integer> IDs) {
        boolean modified = false;
        for (int ID : IDs) {
            if (!this.select(ID)) continue;
            modified = true;
        }
        return modified;
    }

    public boolean deselectAll(Collection<Integer> IDs) {
        boolean modified = false;
        for (int ID : IDs) {
            if (!this.deselect(ID)) continue;
            modified = true;
        }
        return modified;
    }

    public void selectAll() {
        this.selectAll(this.getAllIDs());
    }

    public void deselectAll() {
        this.deselectAll(this.getAllIDs());
    }

    public Set<Integer> getSelectedIDs() {
        return this.selectedView;
    }

    public Set<Integer> getUnselectedIDs() {
        return this.unselectedView;
    }

    public Set<Integer> getAllIDs() {
        return this.allView;
    }

    public int getNumSelectedIDs() {
        return this.getSelectedIDs().size();
    }

    public int getNumUnselectedIDs() {
        return this.getUnselectedIDs().size();
    }

    public int getTotalNumIDs() {
        return this.getAllIDs().size();
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        SubsetSolution otherSubsetSolution = (SubsetSolution)other;
        return Objects.equals(this.getSelectedIDs(), otherSubsetSolution.getSelectedIDs()) && Objects.equals(this.getUnselectedIDs(), otherSubsetSolution.getUnselectedIDs());
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 23 * hash + Objects.hashCode(this.getSelectedIDs());
        hash = 23 * hash + Objects.hashCode(this.getUnselectedIDs());
        return hash;
    }

    public String toString() {
        return this.getSelectedIDs().stream().map(Object::toString).collect(Collectors.joining(", ", "Subset solution: {", "}"));
    }
}

