/*
 * Decompiled with CFR 0.152.
 */
package uno.informatics.data.utils;

public class DataOption {
    private String key;
    private Object value;

    public DataOption(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Key not defined.");
        }
        this.key = key;
    }

    public DataOption(String key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("Key not defined.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value not defined.");
        }
        this.key = key;
        this.value = value;
    }

    public final String getKey() {
        return this.key;
    }

    public final void setKey(String key) {
        this.key = key;
    }

    public final Object getValue() {
        return this.value;
    }

    public final void setValue(Object value) {
        this.value = value;
    }

    public static final boolean hasOption(DataOption[] options, String key) {
        boolean found = false;
        if (options != null && key != null) {
            for (int i = 0; !found && i < options.length; ++i) {
                if (options[i] == null || !key.equals(options[i].getKey())) continue;
                found = true;
            }
        }
        return found;
    }

    public static final <T> T findValue(DataOption[] options, String key, Class<T> type) {
        return DataOption.findValue(options, key, type, null);
    }

    public static final <T> T findValue(DataOption[] options, String key, Class<T> type, T defaultValue) {
        Object value = null;
        if (options != null && key != null) {
            for (int i = 0; value == null && i < options.length; ++i) {
                if (options[i] == null || !key.equals(options[i].getKey())) continue;
                value = options[i].getValue();
            }
        }
        if (type.isInstance(value)) {
            return (T)value;
        }
        return defaultValue;
    }
}

