% Generated by roxygen2 (4.0.2): do not edit by hand
\name{MBContour}
\alias{MBContour}
\title{Computes Multiplier Bootstrap realizations of the supremum of a Gaussian
field on a contour.}
\usage{
MBContour(x, y, R, f, level, N = 1000)
}
\arguments{
\item{x}{x-Coordinates of the grid on which the data is observed.}

\item{y}{y-Coordinates of the grid on which the data is observed.}

\item{R}{An array of dimension c(length(x),length(y),n) containing the
realizations of the field.}

\item{f}{A matrix of dimension c(length(x),length(y)). The contour on which
tail probabilities are to be computed is defind as {f=c}.}

\item{level}{The level of the contour.}

\item{N}{The number of Bootstrap realizations to produce. Default is 1000.}
}
\value{
A vector of length N containing the Bootstrap realizations of the
        supremum.
}
\description{
Computes Multiplier Bootstrap realizations of the supremum of a Gaussian
field on a contour.
}

