% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cubehelix.R
\name{cubehelix}
\alias{cubehelix}
\title{Cube Helix colour palette}
\usage{
cubehelix(n, r = 1.5, hue = 1, gamma = 1, rev = FALSE)
}
\arguments{
\item{n}{integer number of colours in the scale}

\item{r}{real number specifying the number of rotations of the helix over the scale}

\item{hue}{non-negative number specifying the colour intensity from grey (0) to normal (1) and over-saturated (>1)}

\item{gamma}{positive number specifying the relative importance of low vs high values}

\item{rev}{logical flag indicating whether the ordering of the colors should be reversed}
}
\value{
Returns an n-vector of RGB colour strings.
}
\description{
Generate the Cube Helix colour palette, designed to appropriately display of intensity images, as the brightness increases monotonically when displayed in greyscale.
}
\details{
This scheme was published by Green, D. A., 2011, "A colour scheme for the display of astronomical intensity images." Bulletin of the Astronomical Society of India, 39, 289.
}
\author{
Danail Obreschkow
}
