% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svychu.R
\name{svychu}
\alias{svychu}
\alias{svychu.survey.design}
\alias{svychu.svyrep.design}
\alias{svychu.DBIsvydesign}
\title{CHU class of poverty measures (EXPERIMENTAL)}
\usage{
svychu(formula, design, ...)

\method{svychu}{survey.design}(
  formula,
  design,
  g,
  type_thresh = "abs",
  abs_thresh = NULL,
  percent = 0.6,
  quantiles = 0.5,
  na.rm = FALSE,
  thresh = FALSE,
  ...
)

\method{svychu}{svyrep.design}(
  formula,
  design,
  g,
  type_thresh = "abs",
  abs_thresh = NULL,
  percent = 0.6,
  quantiles = 0.5,
  na.rm = FALSE,
  thresh = FALSE,
  ...
)

\method{svychu}{DBIsvydesign}(formula, design, ...)
}
\arguments{
\item{formula}{a formula specifying the income variable}

\item{design}{a design object of class \code{survey.design} or class \code{svyrep.design} from the \code{survey} library.}

\item{...}{passed to \code{svyarpr} and \code{svyarpt}}

\item{g}{A parameter where (1 - g) defines the inequality aversion among the poor. If g = 0, the CHU class becomes a monotonic transform of the Watts poverty measure.}

\item{type_thresh}{type of poverty threshold. If "abs" the threshold is fixed and given the value
of abs_thresh; if "relq" it is given by percent times the quantile; if "relm" it is percent times the mean.}

\item{abs_thresh}{poverty threshold value if type_thresh is "abs"}

\item{percent}{the multiple of the the quantile or mean used in the poverty threshold definition}

\item{quantiles}{the quantile used used in the poverty threshold definition}

\item{na.rm}{Should cases with missing values be dropped?}

\item{thresh}{return the poverty threshold value}
}
\value{
Object of class "\code{cvystat}", which are vectors with a "\code{var}" attribute giving the variance and a "\code{statistic}" attribute giving the name of the statistic.
}
\description{
Estimate the Clark, Hemming and Ulph (1981) class of poverty measures
}
\details{
you must run the \code{convey_prep} function on your survey design object immediately after creating it with the \code{svydesign} or \code{svrepdesign} function.
}
\note{
This function is experimental and is subject to change in later versions.
}
\examples{
library(survey)
library(laeken)
data(eusilc) ; names( eusilc ) <- tolower( names( eusilc ) )

# linearized design

des_eusilc <- svydesign( ids = ~rb030 , strata = ~db040 ,  weights = ~rb050 , data = eusilc )
des_eusilc <- convey_prep( des_eusilc )

# replicate-weighted design
des_eusilc_rep <- as.svrepdesign( des_eusilc , type = "bootstrap" )
des_eusilc_rep <- convey_prep( des_eusilc_rep )

# absolute poverty threshold
svychu(~eqincome, des_eusilc, g=1,  abs_thresh=10000)
# poverty threshold equal to arpt
svychu(~eqincome, des_eusilc, g=1, type_thresh= "relq" , thresh = TRUE)
# poverty threshold equal to 0.6 times the mean
svychu(~eqincome, des_eusilc, g=1, type_thresh= "relm" , thresh = TRUE)

#  using svrep.design:
# absolute poverty threshold
svychu(~eqincome, des_eusilc_rep, g=1,  abs_thresh=10000)
# poverty threshold equal to arpt
svychu(~eqincome, des_eusilc_rep, g=1, type_thresh= "relq" , thresh = TRUE)
# poverty threshold equal to 0.6 times the mean
svychu(~eqincome, des_eusilc_rep, g=1, type_thresh= "relm" , thresh = TRUE)

\dontrun{

# database-backed design
library(RSQLite)
library(DBI)
dbfile <- tempfile()
conn <- dbConnect( RSQLite::SQLite() , dbfile )
dbWriteTable( conn , 'eusilc' , eusilc )

dbd_eusilc <-
	svydesign(
		ids = ~rb030 ,
		strata = ~db040 ,
		weights = ~rb050 ,
		data="eusilc",
		dbname=dbfile,
		dbtype="SQLite"
	)


dbd_eusilc <- convey_prep( dbd_eusilc )

# absolute poverty threshold
svychu(~eqincome, dbd_eusilc, g=1,  abs_thresh=10000)
# poverty threshold equal to arpt
svychu(~eqincome, dbd_eusilc, g=1, type_thresh= "relq" , thresh = TRUE)
# poverty threshold equal to 0.6 times the mean
svychu(~eqincome, dbd_eusilc, g=1, type_thresh= "relm" , thresh = TRUE)

dbRemoveTable( conn , 'eusilc' )

dbDisconnect( conn , shutdown = TRUE )

}

}
\references{
Vijay Verma and Gianni Betti (2011). Taylor linearization sampling errors and design effects for poverty measures
and other complex statistics. \emph{Journal Of Applied Statistics}, Vol.38, No.8, pp. 1549-1576,
URL \url{http://dx.doi.org/10.1080/02664763.2010.515674}.

Anthony B. Atkinson (1987). On the measurement of poverty.
\emph{Econometrica}, Vol.55, No.4, (Jul., 1987), pp. 749-764,
URL \url{http://www.jstor.org/stable/1911028}.

Stephen Clark, Richard Hemming and David Ulph (1981). On Indices
for the Measurement of Poverty. \emph{The Economic Journal}, Vol.91, No.362, (Jun., 1981), pp. 515-526,
URL \url{http://www.jstor.org/stable/2232600}.

Guillaume Osier (2009). Variance estimation for complex indicators
of poverty and inequality. \emph{Journal of the European Survey Research
Association}, Vol.3, No.3, pp. 167-195,
ISSN 1864-3361, URL \url{http://ojs.ub.uni-konstanz.de/srm/article/view/369}.
}
\seealso{
\code{\link{svywatts}}
}
\author{
Guilherme Jacob, Djalma Pessoa and Anthony Damico
}
\keyword{survey}
