% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_funs.R
\name{densfun}
\alias{densfun}
\title{Estimate the derivative of the cdf function using kernel estimator}
\usage{
densfun(formula, design, x, h = NULL, FUN = "F", na.rm = FALSE, ...)
}
\arguments{
\item{formula}{a formula specifying the income variable}

\item{design}{a design object of class \code{survey.design} from the \code{survey} library.}

\item{x}{the point where the derivative is calculated}

\item{h}{value of the bandwidth based on the whole sample}

\item{FUN}{if \code{F} estimates the derivative of the cdf function; if \code{big_s} estimates the derivative of total in the tails of the distribution}

\item{na.rm}{Should cases with missing values be dropped?}

\item{...}{future expansion}
}
\value{
the value of the derivative at \code{x}
}
\description{
computes the derivative of a function in a point using kernel estimation
}
\examples{
library(vardpoor)
data(eusilc) ; names( eusilc ) <- tolower( names( eusilc ) )
library(survey)
des_eusilc <- svydesign(ids = ~rb030, strata =~db040,  weights = ~rb050, data = eusilc)
des_eusilc <- convey_prep( des_eusilc )
densfun (~eqincome, design=des_eusilc, 10000, FUN="F" )
# linearized design using a variable with missings
densfun ( ~ py010n , design = des_eusilc, 10000, FUN="F" )
densfun ( ~ py010n , design = des_eusilc , 10000,FUN="F", na.rm = TRUE )

}
\author{
Djalma Pessoa and Anthony Damico
}
\keyword{survey}

