% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertId2.R
\name{get.bm}
\alias{get.bm}
\title{Make a Query to Biomart.}
\usage{
get.bm(
  values,
  biom.data.set = c("human", "mouse"),
  biom.mart = c("ensembl", "mouse", "snp", "funcgen", "plants"),
  host = "www.ensembl.org",
  biom.filter = "ensembl_gene_id",
  biom.attributes = c("ensembl_gene_id", "hgnc_symbol", "description")
)
}
\arguments{
\item{values}{\code{character} vector of ids to be converted.}

\item{biom.data.set}{\code{character} of length one. Biomart data set to use. Defaults to 'human' (internally translated to "hsapiens_gene_ensembl" if `biom.mart="ensembl"`).}

\item{biom.mart}{\code{character} vector. Biomart to use (uses the first element of the vector), defaults to "ensembl".}

\item{host}{\code{character} of length one. Host URL.}

\item{biom.filter}{\code{character} of length one. Name of biomart filter, i.e., type of query ids, defaults to "ensembl_gene_id".}

\item{biom.attributes}{\code{character} vector. Biomart attributes, i.e., type of desired result(s); make sure query id type is included!}
}
\value{
A data frame with the retrieved information.
}
\description{
\command{get.bm} is a user-friendly wrapper for \command{getBM} from the \emph{biomaRt} package with default
    settings for Human and Mouse.
It sets all needed variables and performs the query.
}
\examples{
\dontrun{
val <- c("ENSG00000111199", "ENSG00000134121", "ENSG00000176102", "ENSG00000171611")
bm <- get.bm(val)
bm
}
}
\seealso{
\command{\link[biomaRt]{getBM}}
}
\author{
Vidal Fey
}
\keyword{utilities}
