% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{BETABINOMIAL}
\alias{BETABINOMIAL}
\alias{new_BETABINOMIAL}
\alias{new_BETABINOMIAL_od}
\alias{new_BETABINOMIAL_icc}
\title{Factory for a BETABINOMIAL distribution object}
\usage{
new_BETABINOMIAL(p_size, p_shape1, p_shape2, p_dimnames = "rvar")

new_BETABINOMIAL_od(p_size, p_mu, p_od, p_dimnames = "rvar")

new_BETABINOMIAL_icc(p_size, p_mu, p_icc, p_dimnames = "rvar")
}
\arguments{
\item{p_size}{a non-negative parameter for the number of trials}

\item{p_shape1}{non-negative parameters of the Betabinomial distribution}

\item{p_shape2}{non-negative parameters of the Betabinomial distribution}

\item{p_dimnames}{A character that represents the name of the dimension}

\item{p_mu}{mean proportion for the binomial part of the distribution}

\item{p_od}{over dispersion parameter}

\item{p_icc}{intra-class correlation parameter}
}
\value{
An object of class \code{DISTRIBUTION}, \code{BETADISTRIBUION}
}
\description{
Returns an BETABINOMIAL distribution object that produce random numbers
from a  betabinomial distribution using the \code{\link[extraDistr]{rbbinom}} function
}
\section{Functions}{
\itemize{
\item \code{new_BETABINOMIAL_od()}: parametrization based on dispersion

\item \code{new_BETABINOMIAL_icc()}: parametrization based on intra-class correlation

}}
\note{
There are several parametrization for the betabinomial distribution.
The one based on shape1 and shape2 are parameters alpha and beta of the beta
part of the distribution, but it can be parametrized as mu, and od where mu is the 
expected mean proportion and od is a measure of the overdispersion. 

\eqn{p_mu = p_shape1/(p_shape1 + p_shape2)}

\eqn{p_od = p_shape1 + p_shape2}

\eqn{p_shape1 = p_mu*p_od}

\eqn{p_shape2 <- (1-p_mu)*p_od}

Another parametrization is based on mu and the icc where mu is the mean
proportion and icc is the intra-class correlation.

\eqn{p_mu = p_shape1/(p_shape1 + p_shape2)}

\eqn{p_icc = 1/(p_shape1 + p_shape2 + 1)}

\eqn{p_shape1 = p_mu*(1-p_icc)/p_icc}

\eqn{p_shape2 = (1-p_mu)*(1-p_icc)/p_icc}
}
\examples{
myDistr <- new_BETABINOMIAL(10,1,1)
myDistr$rfunc(10)
}
\author{
John J. Aponte
}
