% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClopperPearson_exact_CI_1x2_beta_version.R
\name{ClopperPearson_exact_CI_1x2_beta_version}
\alias{ClopperPearson_exact_CI_1x2_beta_version}
\title{The Clopper-Pearson exact confidence interval for the binomial probability (beta version)}
\usage{
ClopperPearson_exact_CI_1x2_beta_version(X, n, alpha = 0.05)
}
\arguments{
\item{X}{the number of successes}

\item{n}{the total number of observations}

\item{alpha}{the nominal level, e.g. 0.05 for 95# CIs}
}
\value{
An object of the \link{contingencytables_result} class,
basically a subclass of \code{\link[base:list]{base::list()}}. Use the \code{\link[utils:str]{utils::str()}} function
to see the specific elements returned.
}
\description{
The Clopper-Pearson exact confidence interval for the binomial probability

(defined via the beta distribution)

Described in Chapter 2 "The 1x2 Table and the Binomial Distribution"
}
\examples{
ClopperPearson_exact_CI_1x2_beta_version(singh_2010["1st", "X"], singh_2010["1st", "n"])
ClopperPearson_exact_CI_1x2_beta_version(singh_2010["2nd", "X"], singh_2010["2nd", "n"])
ClopperPearson_exact_CI_1x2_beta_version(singh_2010["3rd", "X"], singh_2010["3rd", "n"])
with(singh_2010["4th", ], ClopperPearson_exact_CI_1x2_beta_version(X, n)) # alternative syntax
ClopperPearson_exact_CI_1x2_beta_version(ligarden_2010["X"], ligarden_2010["n"])
}
\references{
Brown LD, Cai T, DasGupta A (2001) Interval estimation for a
binomial proportion. Statistical Science; 16:101-133
}
\seealso{
ClopperPearson_exact_CI_1x2
}
