% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Exact_unconditional_test_2x2.R
\name{Exact_unconditional_test_2x2}
\alias{Exact_unconditional_test_2x2}
\title{Exact unconditional test for association in 2x2 tables}
\usage{
Exact_unconditional_test_2x2(
  n,
  statistic = "Pearson",
  gamma = 1e-04,
  printresults = TRUE
)
}
\arguments{
\item{n}{the observed counts (a 2x2 matrix)}

\item{statistic}{'Pearson' (Suissa-Shuster test default), 'LR' (likelihood ratio),
' unpooled' (unpooled Z), or 'Fisher' (Fisher-Boschloo test)}

\item{gamma}{parameter for the Berger and Boos procedure (default=0.0001 gamma=0: no adj)}

\item{printresults}{display results (F = no, T = yes)}
}
\value{
Fisher's exact test statistic
}
\description{
Exact unconditional test for association in 2x2 tables

Described in Chapter 4 "The 2x2 Table"
}
\note{
Somewhat crude code with maximization over a simple partition of the
nuisance parameter space into 'num_pi_values' equally spaced values
(default: 1000). The number may be changed below.
This method could be improved with a better algorithm for the
maximization however, it works well for most purposes. Try 'showplot=TRUE'
to get an indication of the precision. A refinement of the maximization
can be done with a manual restriction of the parameter space.
}
\examples{
n <- rbind(c(3, 1), c(1, 3)) # Example: A lady tasting a cup of tea
Exact_unconditional_test_2x2(n)
n <- rbind(c(7, 27), c(1, 33)) # Example: Perondi et al. (2004)
Exact_unconditional_test_2x2(n)
n <- rbind(c(9, 4), c(4, 10)) # Example: Lampasona et al. (2013)
Exact_unconditional_test_2x2(n)
n <- rbind(c(0, 16), c(15, 57)) # Example: Ritland et al. (2007)
Exact_unconditional_test_2x2(n)
}
