% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conos.R
\name{bestClusterTreeThresholds}
\alias{bestClusterTreeThresholds}
\title{Find threshold of cluster detectability in trees of clusters}
\usage{
bestClusterTreeThresholds(res, leaf.factor, clusters, clmerges = NULL)
}
\arguments{
\item{res}{walktrap result object (igraph) where the nodes were clusters}

\item{leaf.factor}{a named factor describing cell assignments to the leaf nodes (in the same order as res$names)}

\item{clusters}{cluster factor}

\item{clmerges}{integer matrix of cluster merges (default=NULL). If NULL, the function treeJaccard() performs calculation without it.}
}
\value{
a list of $thresholds - per cluster optimal detectability values, and $node - internal node id (merge row) where the optimum was found
}
\description{
For a given clustering, walks the walktrap (of clusters) result tree to find
a subtree with max(min(sens,spec)) for each cluster, where sens is sensitivity, spec is specificity
}
