% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnt_generics.R, R/fs_methods.R
\name{upload_directory_cnt}
\alias{upload_directory_cnt}
\alias{upload_directory_cnt.ConnectorFS}
\title{Upload a directory}
\usage{
upload_directory_cnt(
  connector_object,
  dir,
  name,
  overwrite = zephyr::get_option("overwrite", "connector"),
  open = FALSE,
  ...
)

\method{upload_directory_cnt}{ConnectorFS}(
  connector_object,
  dir,
  name,
  overwrite = zephyr::get_option("overwrite", "connector"),
  open = FALSE,
  ...
)
}
\arguments{
\item{connector_object}{\link{Connector} The connector object to use.}

\item{dir}{\link{character} Path to the directory to upload}

\item{name}{\link{character} The name of the new directory to place the content in}

\item{overwrite}{Overwrite existing content if it exists in the connector?. Default: \code{FALSE}.}

\item{open}{\link{logical} Open the directory as a new connector object.}

\item{...}{Additional arguments passed to the method for the individual connector.}
}
\value{
\link{invisible} connector_object.
}
\description{
Generic implementing of how to upload a directory for a connector.
Mostly relevant for file storage connectors.

\itemize{
\item \link{ConnectorFS}: Uses \code{\link[fs:copy]{fs::dir_copy()}}.
}
}
