% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thumbnail.R
\name{set_image_path}
\alias{set_image_path}
\alias{set_image_url}
\alias{set_image_webshot}
\title{Set the Content Image}
\usage{
set_image_path(content, path)

set_image_url(content, url)

set_image_webshot(content, ...)
}
\arguments{
\item{content}{A content object}

\item{path}{The path to an image on disk}

\item{url}{The url for an image}

\item{...}{Additional arguments passed on to \code{\link[webshot2:webshot]{webshot2::webshot()}}}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

Please use \code{\link{set_thumbnail}} instead.

Set the Content Image using a variety of methods.
}
\details{
NOTE: \code{set_image_webshot()} requires \code{\link[webshot2:webshot]{webshot2::webshot()}}, but currently
skips and warns for any content that requires authentication until the
\code{webshot2} package supports authentication.
}
\seealso{
Other content functions: 
\code{\link{content_delete}()},
\code{\link{content_item}()},
\code{\link{content_title}()},
\code{\link{content_update}()},
\code{\link{create_random_name}()},
\code{\link{dashboard_url}()},
\code{\link{dashboard_url_chr}()},
\code{\link{delete_thumbnail}()},
\code{\link{delete_vanity_url}()},
\code{\link{deploy_repo}()},
\code{\link{get_bundles}()},
\code{\link{get_environment}()},
\code{\link{get_image}()},
\code{\link{get_job}()},
\code{\link{get_jobs}()},
\code{\link{get_log}()},
\code{\link{get_thumbnail}()},
\code{\link{get_vanity_url}()},
\code{\link{git}},
\code{\link{has_thumbnail}()},
\code{\link{permissions}},
\code{\link{set_run_as}()},
\code{\link{set_thumbnail}()},
\code{\link{set_vanity_url}()},
\code{\link{swap_vanity_url}()},
\code{\link{swap_vanity_urls}()},
\code{\link{terminate_jobs}()},
\code{\link{verify_content_name}()}
}
\concept{content functions}
