% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sen_coalition_info.R
\name{sen_coalition_info}
\alias{sen_coalition_info}
\title{Downloads and tidies data on specific coalitions in the Federal Senate}
\usage{
sen_coalition_info(code = NULL, ascii = TRUE)
}
\arguments{
\item{code}{\code{integer}. Code of the coalition. If not known (the most likely
case), these codes can be obtained from the \code{sen_coalitions()} function.}

\item{ascii}{\code{logical}. If TRUE, names are converted to ascii format.}
}
\value{
A tibble, of classes \code{tbl_df}, \code{tbl} and \code{data.frame},
with variables:
\itemize{
 \item{\code{bloc_code: }}{unique code given to each coalition.}
 \item{\code{house: }}{legislative house for the coalition.}
 \item{\code{bloc_name: }}{name of the coalition.}
 \item{\code{bloc_label: }}{additional label for the coalition.}
 \item{\code{date_created: }}{\code{POSIXct}, date the coalition was created.}
 \item{\code{member_code: }}{party code.}
 \item{\code{member_date_joined: }}{\code{POSIXct}, date when the party first joined the coalition.}
 \item{\code{member_abbr: }}{party acronym.}
 \item{\code{member_name: }}{party name.}
 \item{\code{member_date_created:: }}{\code{POSIXct}, date when the coalition was created.}
}
}
\description{
Downloads and tidies data on specific coalitions in the Federal Senate.
}
\author{
Robert Myles McDonnell, Guilherme Jardim Duarte & Danilo Freire.
}
