% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sen_commission_list.R
\name{sen_commissions_senators}
\alias{sen_commissions_senators}
\title{Information on the senators who serve on a certain commission in the
 Federal Senate}
\usage{
sen_commissions_senators(code = NULL, ascii = TRUE)
}
\arguments{
\item{code}{\code{character}. Character code (abbreviation) of the
commission requested. A list of these may be obtained with \code{sen_commissions()}, although not all of the abbreviations in this data frame will return information.}

\item{ascii}{\code{logical}. If TRUE, certain strings are converted to ascii
format.}
}
\value{
A tibble, of classes \code{tbl_df}, \code{tbl} and \code{data.frame}.
}
\description{
Information on the senators who serve on a certain commission in the
 Federal Senate.
}
\details{
Returns a data frame with the following variables:
\itemize{
 \item{\code{commission: }}{name of the commission.}
 \item{\code{commission_abbr: }}{abbreviated name of the commission.}
 \item{\code{senator_id: }}{unique code for each senator.}
 \item{\code{senator_name}}
 \item{\code{senator_party}}
 \item{\code{senator_state}}
}
}
\examples{
# get info on the senators who serve on the CCJ commission:
ccj <- sen_commissions_senators(code = "CCJ")

}
\author{
Robert Myles McDonnell, Guilherme Jardim Duarte & Danilo Freire.
}
