% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jackplus.R
\name{conformal.multidim.jackplus}
\alias{conformal.multidim.jackplus}
\title{Multivariate Response Jackknife + Prediction Regions}
\usage{
conformal.multidim.jackplus(x, y, x0, train.fun, predict.fun, alpha = 0.1)
}
\arguments{
\item{x}{The feature variables, a matrix n x p.}

\item{y}{The matrix of multivariate responses (dimension n x q)}

\item{x0}{The new points to evaluate, a matrix of dimension n0 x p.}

\item{train.fun}{A function to perform model training, i.e., to produce an
estimator of E(Y|X), the conditional expectation of the response variable
Y given features X. Its input arguments should be x: matrix of features,
and y: matrix of responses.}

\item{predict.fun}{A function to perform prediction for the (mean of the)
responses at new feature values. Its input arguments should be out: output
produced by train.fun, and newx: feature values at which we want to make
predictions.}

\item{alpha}{Miscoverage level for the prediction intervals, i.e., intervals
with coverage 1-alpha are formed. Default for alpha is 0.1.}
}
\value{
A list with length n0, giving the lower and upper bounds for each observation.
}
\description{
Compute prediction regions using multivariate Jackknife + inference.
}
\details{
The work is an extension of the univariate approach to jackknife +
 inference to a multivariate context, exploiting the concept of depth measures.

This function is based on the package future.apply to
 perform parallelisation. If this package is not installed, then the function
 will abort.
}
\examples{
## One instance

n=50
p=3
q=2
mu=rep(0,p)
x = mvtnorm::rmvnorm(n, mu)
beta<-sapply(1:q, function(k) c(mvtnorm::rmvnorm(1,mu)))
y = x\%*\%beta + t(mvtnorm::rmvnorm(q,1:n))
x0=matrix(x[n,],nrow=1)
y0=matrix(y[n,],nrow=1)
n0<-nrow(y0)
funs=lm_multi()

sol<-conformal.multidim.jackplus(x,y,x,train.fun = funs$train.fun,
                                      predict.fun = funs$predict.fun,alpha=0.05)

sol



}
