% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{get}
\alias{get}
\title{Read configuration values}
\usage{
get(value = NULL, config = Sys.getenv("R_CONFIG_ACTIVE", "default"),
  file = "config.yml", use_parent = TRUE)
}
\arguments{
\item{value}{Name of value (\code{NULL} to read all values)}

\item{config}{Name of configuration to read from. Defaults to
the value of the \code{R_CONFIG_NAME} environment variable
("default" if the variable does not exist).}

\item{file}{Configuration file to read from (defaults to
"config.yml"). If the file isn't found at the location
specified then parent directories are searched for a file
of the same name.}

\item{use_parent}{\code{TRUE} to scan parent directories for
configuration files if the specified config file isn't found.}
}
\value{
The requested configuration value (or all values as
  a list of \code{NULL} is passed for \code{value}).
}
\description{
Read from the currently active configuration, retreiving either a
single named value or all values as a list.
}
\details{
For additional details see the package website at
 \href{https://github.com/rstudio/config}{https://github.com/rstudio/config}.
}

