% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/condor_q.R
\name{condor_q}
\alias{condor_q}
\title{Condor Queue}
\usage{
condor_q(all = FALSE, count = FALSE, user = "", session = NULL)
}
\arguments{
\item{all}{whether to list jobs from all users.}

\item{count}{whether to only show the number of jobs.}

\item{user}{username to list jobs submitted by a given user.}

\item{session}{optional object of class \code{ssh_connect}.}
}
\value{
No return value, called for side effects.
}
\description{
List the Condor job queue.
}
\details{
The default value of \code{session = NULL} looks for a \code{session} object
in the user workspace. This allows the user to run Condor functions without
explicitly specifying the \code{session}.
}
\examples{
\dontrun{

# General workflow
session <- ssh_connect("servername")

condor_submit()
condor_q()
condor_dir()
condor_download()  # after job has finished

# Alternatively, list number of jobs being run by each user
condor_q(all=TRUE, count=TRUE)
}

}
\seealso{
\code{\link{condor_submit}}, \code{\link{condor_q}},
\code{\link{condor_dir}}, and \code{condor_download} provide the main Condor
interface.

\code{\link{condor_rm}} stops Condor jobs and \code{\link{condor_rmdir}}
removes directories on the submitter machine.

\code{\link{condor-package}} gives an overview of the package.
}
\author{
Arni Magnusson.
}
