% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curve_lik.R
\name{curve_lik}
\alias{curve_lik}
\title{Compute Profile Likelihood Functions}
\usage{
curve_lik(likobject, data, table = TRUE)
}
\arguments{
\item{likobject}{An object from the ProfileLikelihood package}

\item{data}{The dataframe that was used to create the likelihood
object in the ProfileLikelihood package.}

\item{table}{Indicates whether or not a table output with some relevant
statistics should be generated. The default is TRUE and generates a table
which is included in the list object.}
}
\value{
A list with 2 items where the dataframe of values is in the first
object, and the table for the values in the second if table = TRUE.
}
\description{
Compute Profile Likelihood Functions
}
\examples{

library(ProfileLikelihood)
data(dataglm)
xx <- profilelike.glm(y ~ x1 + x2, dataglm, profile.theta = "group", binomial("logit"))
lik <- curve_lik(xx, dataglm)
}
