% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_matchups}
\alias{get_matchups}
\title{Get matchups from competition results}
\usage{
get_matchups(cr_data)
}
\arguments{
\item{cr_data}{Competition results ready for \code{\link[=as_longcr]{as_longcr()}}.}
}
\value{
A \link{widecr} for games with two players.
}
\description{
This function powers computing Head-to-Head values (both \link[=h2h_long]{long} and
\link[=h2h_mat]{matrix}).
}
\details{
\code{get_matchups()} returns a \link[tibble:tibble]{tibble} of all
matchups (pairs of players from one game) \strong{actually present} in \code{cr_data}
(including matchups of players with themselves).
It has following columns:
\itemize{
\item \code{game} - game identifier of matchup.
\item \code{player1} - identifier of first player in matchup.
\item \code{score1} - score of the first player in matchup.
\item \code{player2} - identifier of second player in matchup.
\item \code{score2} - score of the second player in matchup.
}

\strong{Important notes}:
\itemize{
\item Matchups are not symmetrical: matchup "player1"-"player2" is considered
different from "player2"-"player1" in order to except more advanced, not
symmetrical Head-to-Head values.
\item Missing values in \code{player} column after conversion to \code{longcr} are treated
as separate players. It allows operating with games where multiple players'
identifiers are not known. However, when computing Head-to-Head values they
treated as single player.
}
}
\examples{
get_matchups(ncaa2005)

}
\seealso{
\link[=h2h_long]{Long format} of Head-to-Head values.

\link[=h2h_mat]{Matrix format} of Head-to-Head values.
}
